<?php
# set charset to UTF-8
header("Content-Type: text/html; charset=utf-8");

######################################################################
# set name of your template path here!
$template_path = 'templates';
######################################################################

$jsonfile = "https://api.volxmusik.de/Events/";

$httpget = 1; 
# get and validate POST variables and set query vars
if (preg_match ("/^\d+$/",$_POST["id"],$matches)) { $query["id"] = $matches[0]; $httpget = 0; } # ID of single event 
if (preg_match ("^\d{10}^",$_POST["s"],$matches)) { $query["s"] = $matches[0]; $httpget = 0; }  # Start of period of events 
if (preg_match ("^\d{10}^",$_POST["e"],$matches)) { $query["e"] = $matches[0]; $httpget = 0; }  # End of period of events
if (preg_match ("#^[0-9]+(,[0-9]+)*#",urldecode ($_POST["r"]),$matches)) { $query["r"] = $matches[0]; $httpget = 0; }  # Event region(s)
if (preg_match ("#^[0-9]+(,[0-9]+)*#",urldecode ($_POST["c"]),$matches)) { $query["c"] = $matches[0]; $httpget = 0; }  # Event categories
if (preg_match ("/^-?[0-9]+$/",$_POST["limit"],$matches)) { $query["limit"] = $matches[0]; $httpget = 0; }  # ID of single event 
if (preg_match ("/^-?[0-9]+$/",$_POST["offset"],$matches)) { $query["offset"] = $matches[0]; $httpget = 0; }  # ID of single event 

# get params via GET only if there are no POST Data
if ($httpget == 1) {
	if (preg_match ("/^\d+$/",$_GET["id"],$matches)) $query["id"] = $matches[0]; # ID of single event 
	if (preg_match ("^\d{10}^",$_GET["s"],$matches)) $query["s"] = $matches[0]; # Start of period of events 
	if (preg_match ("^\d{10}^",$_GET["e"],$matches)) $query["e"] = $matches[0]; # End of period of events
	if (preg_match ("#^[0-9]+(,[0-9]+)*#",urldecode ($_GET["r"]),$matches)) $query["r"] = $matches[0]; # Event region(s)
	if (preg_match ("#^[0-9]+(,[0-9]+)*#",urldecode ($_GET["c"]),$matches)) $query["c"] = $matches[0]; # Event categories
	if (preg_match ("/^-?[0-9]+$/",$_GET["limit"],$matches)) $query["limit"] = $matches[0]; # ID of single event 
	if (preg_match ("/^-?[0-9]+$/",$_GET["offset"],$matches)) $query["offset"] = $matches[0]; # ID of single event
} 

# create curl resource 
$ch = curl_init(); 

# set url 
curl_setopt($ch, CURLOPT_URL, $jsonfile); 

# return the transfer as a string 
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

# post query vars
curl_setopt($ch, CURLOPT_POSTFIELDS, $query);

# $jsondata contains the output string 
$jsondata = curl_exec($ch); 

# close curl resource to free up system resources 
curl_close($ch);   

# debug $jsondata
#echo $jsondata;

# convert JSON data to array
$events = json_decode($jsondata, true);
# debug json_decode error
#echo json_last_error_msg()."<br>";

# display array values
#echo "<pre>";
#print_r($events);
#echo "</pre>";

# define event functions
include $_SERVER['DOCUMENT_ROOT'].$template_path.'/includes/inc_event_functions.html5';

if($query["id"]) {
# if event ID is given then display single event
include $_SERVER['DOCUMENT_ROOT'].$template_path.'/includes/json_event.html5';
}
else {
# display list of events
include $_SERVER['DOCUMENT_ROOT'].$template_path.'/includes/json_eventlist.html5';
}
?>